import Modulalogo from '@img/modula.png';
import SlackLogo from '@img/slack.svg';
import GSheetsLogo from '@img/gsheets.svg';
const { __ } = wp.i18n;
export default [
	{
		id: 'general',
		iconType: 'icon',
		icon: 'icon-settings',
		text: __('General', 'kali-forms'),
		pro: false,
		check: true,
	},
	{
		id: 'styling',
		iconType: 'icon',
		icon: 'icon-brush',
		text: __('Form styling', 'kali-forms'),
		pro: false,
		check: true,
	},
	{
		id: 'spam',
		iconType: 'icon',
		icon: 'icon-spam',
		text: __('Spam protection', 'kali-forms'),
		pro: false,
		check: true,
	},
	{
		id: 'conditionalLogic',
		iconType: 'icon',
		icon: 'icon-logic',
		text: __('Conditional logic', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'payments',
		iconType: 'icon',
		icon: 'icon-payment',
		text: __('Payments', 'kali-forms'),
		pro: false,
		check: true,
	},
	{
		id: 'stripeSettings',
		iconType: 'icon',
		icon: 'icon-stripe',
		text: __('Stripe settings', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.payments !== 'undefined',
	},
	{
		id: 'userRegistration',
		iconType: 'icon',
		icon: 'icon-add-user',
		text: __('User registration', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.userRegistrationInstalled !== 'undefined',
	},
	{
		id: 'webhooks',
		iconType: 'icon',
		icon: 'icon-upload-1',
		text: __('Web Hooks', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.webhooksInstalled !== 'undefined',
	},
	{
		id: 'formCalculator',
		iconType: 'icon',
		icon: 'icon-calculator',
		text: __('Calculator', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'formCustomCss',
		iconType: 'icon',
		icon: 'icon-css',
		text: __('Custom CSS', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'formCustomJs',
		iconType: 'icon',
		icon: 'icon-js',
		text: __('Custom JS', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'formCustomPhp',
		iconType: 'icon',
		icon: 'icon-php',
		text: __('Custom PHP', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'newsletter',
		iconType: 'icon',
		icon: 'icon-email',
		text: __('Newsletter', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.newsletterInstalled !== 'undefined',
	},
	{
		id: 'slack',
		iconType: 'image',
		icon: SlackLogo,
		text: __('Slack', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.slackInstalled !== 'undefined',
	},
	{
		id: 'modulaIntegration',
		iconType: 'image',
		icon: Modulalogo,
		text: __('Modula', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.conditionalLogic !== 'undefined',
	},
	{
		id: 'googleSheets',
		iconType: 'image',
		icon: GSheetsLogo,
		text: __('Google sheets', 'kali-forms'),
		pro: true,
		check: typeof KaliFormsObject.googleSheetsInstalled !== 'undefined',
	},
	{
		id: 'conversionBridge',
		iconType: 'icon',
		icon: 'icon-moves',
		text: __('Conversion Bridge', 'kali-forms'),
		pro: false,
		check: true,
	}
];
